TITLE    							                  { exa042.pde }
   'Earth-Moon Gravitation, Close to the Earth'
SELECT
   spectral_colors
DEFINITIONS                                                 	
   d=3.84e8     r1=6.37e6     L=10*r1   	
   m1=5.98e24     m2=7.35e22     		{ Masses of Earth and Moon }
   G=6.67e-11					{ Graviational constant }
   U=-G*m1/sqrt(x^2+y^2)- G*m2/sqrt(x^2+(y-d)^2)
   gx=-dx(U)     gy=-dy(U)                 	{ Field components }
   gv=vector( gx, gy)     gm=sqrt( gx^2+ gy^2)  	{ Vector and magnitude }
   gv_angle=sign(gy)*arccos( gx/gm)/pi*180             	
BOUNDARIES
region 'domain'
   start(-L,-L) line to (L,-L) to (L,L) to (-L,L) close
   start(r1,0) arc( center=0,0) angle=360			{ Exclude Earth }
PLOTS
   grid(x,y)
   contour( gm) as 'Magnitude'     contour( gm) log
   surface( gm) log
   vector( gv/gm)     contour( gv_angle)
END

